﻿var assignmenthistory = {
    context: $(".v-callbacks-assignmenthistory"),
    datatable: null,
    initialize: function () {
        this.datatable = $(".h-assignmenthistory-table", this.context).a4datatable({
            advancedFilter: true,
            ajaxAction: a4.getProjectAction("GetCallbackAssignmentHistory", "Callbacks"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Key": true, "Visible": false },
                //{ "Data": "CaseFilterDetails", Tooltip: true },
                { "Name": "DateTime", "Title": resources.DateTime, "Data": "DateTime", "Type": "datetime" },
                { "Name": "User", "Title": resources.Priority, "Data": "User" },
                { "Name": "FirstCase", "Title": resources.FirstCase, "Data": "FirstCase" },
                { "Name": "LastCase", "Title": resources.LastCase, "Data": "LastCase" },
                { "Name": "Count", "Title": resources.Count, "Data": "Count" }],
            stateKey: "CallbackAssignmentHistory",
            contextMenuItems: [
                { "Action": "viewCasefilter", "Label": resources.CaseFilterDetails },
                { "Action": "viewDescription", "Label": resources.DescriptionDetails },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var projectId = $("#ProjectId", a4.parent().assignments.context).val();

                switch (action) {
                    case "viewCasefilter":
                        modalDialog.showWindow(a4.getProjectAction("HistoryCaseFilterDetails", "Callbacks", { projectId: projectId, id: row.Id }), 300, 500);
                        break
                    case "viewDescription":
                        modalDialog.showWindow(a4.getProjectAction("HistoryDescriptionDetails", "Callbacks", { projectId: projectId, id: row.Id }), 300, 500);
                        break;
                }
            },
            //toolBarItems: [
            //    { "Action": "modifySelectedRespondents", "Label": resources.ModifySelected }
            //],            
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                assignments.casesIds = _.map(rows, function (row) { return row.Id; });

                switch (action) {
                    case "modifySelectedRespondents":
                        //var filter = caseFilter.getFilterObject();
                        modalDialog.showWindow(a4.getProjectAction("CallbackAssignmentModifySelection", "Callbacks", { type: 2, caseIds: 0 }), 650, 750, { afterClose: function () { assignments.refreshContent(); } });
                        break;
                }
            }
        });
    },
    refreshContent: function () {
        assignmenthistory.datatable.a4datatable("refresh");
    }
};

$(document).ready(function () {
    if (assignmenthistory.context.length > 0) {
        assignmenthistory.initialize();        
    }
});